% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rea.R
\name{rea}
\alias{rea}
\title{REA: Rank EnrichmeNt Analysis}
\usage{
rea(signatures, groups, sweights = NULL, gweights = NULL, minsize = 1)
}
\arguments{
\item{signatures}{a named vector, with values as signature values
(e.g. logFC) and names as object names (e.g. gene symbols)}

\item{groups}{a list of vectors of objects (e.g. pathways)}

\item{sweights}{weights associated to objects in the signature.
If NULL (default) all objects are treated according to the signature rank}

\item{gweights}{weights associated to association strength between each
object and each group. If NULL (default) all associations are treated equally}

\item{minsize}{integer. Minimum size of the groups to be analyzed. Default=1}
}
\value{
A numeric vector of normalized enrichment scores
}
\description{
REA Calculates enrichment of groups of objects over a vector of values
associated to a population of objects
}
\examples{
signatures<-setNames(-sort(rnorm(1000)),paste0('gene',1:1000))
set1<-paste0('gene',sample(1:200,50))
set2<-paste0('gene',sample(1:1000,50))
groups<-list(set1=set1,set2=set2)
obj<-rea(signatures=signatures,groups=groups)
obj
}
