% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HDF5NAdrop2matrix.R
\name{HDF5NAdrop2matrix}
\alias{HDF5NAdrop2matrix}
\title{Coerce a NA-dropped HDF5 matrix back to regular matrix form where NAs are not
dropped to 0.}
\usage{
HDF5NAdrop2matrix(hdf5_assay)
}
\arguments{
\item{hdf5_assay}{an DelayedMatrix object with dropped NA values (e.g. an
assay from HDF5SummarizedExpriment object saved by vmrseq::data.pool)}
}
\value{
Returns a matrix.
}
\description{
Coerce a NA-dropped HDF5 matrix back to regular matrix form where NAs are not
dropped to 0.
}
\examples{
# load example data
toy.se <- HDF5Array::loadHDF5SummarizedExperiment(system.file("extdata", "toy", package = "vmrseq"))

# run the function
HDF5NAdrop2matrix(SummarizedExperiment::assays(toy.se)$M_mat)


}
