% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.Seurat.R
\name{as.Seurat}
\alias{as.Seurat}
\title{Convert a \code{SpatialExperiment} object to a \code{Seurat} object}
\usage{
as.Seurat(
  spe,
  spatial_cols = c(tissue = "in_tissue", row = "array_row", col = "array_col", imagerow =
    "pxl_row_in_fullres", imagecol = "pxl_col_in_fullres"),
  verbose = TRUE
)
}
\arguments{
\item{spe}{A
\link[SpatialExperiment:SpatialExperiment]{SpatialExperiment-class} with
\code{colData()} or \code{spatialCoords()}
columns given by \code{spatial_cols}. This does not have to be a stitched
\code{spe} object as this function should work with any type of \code{spe} objects.}

\item{spatial_cols}{A \code{character(5)} named vector mapping which \code{colData(spe)}
or \code{spatialCoords(spe)} columns contain the \code{tissue}, \code{row}, \code{col},
\code{imagerow}, and \code{imagecol} information expected by Seurat.}

\item{verbose}{A \code{logical(1)} vector. If \code{TRUE}, print status update
about the conversion process. This information can be useful for debugging.}
}
\value{
A \code{Seurat} object.
}
\description{
Given a \link[SpatialExperiment:SpatialExperiment]{SpatialExperiment-class}
object, first \code{as.Seurat()} is run, which operates on
\link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment-class}
objects. The remaining components (images, spatial coordinates) are added
manually. The actual appearance of images are buggy for now.
}
\details{
Note that only the \code{lowres} images from \code{imgData(spe)} will be used.
}
\examples{
## Download some example data
spe_unstitched <- spatialLIBD::fetch_data(
    type = "spatialDLPFC_Visium_example_subset"
)[seq(100), seq(100)]

## Make the column names unique
colnames(spe_unstitched) <- spatialLIBD::add_key(spe_unstitched)$key

## Convert from a SpatialExperiment to a Seurat object
seur <- as.Seurat(spe_unstitched)
seur

## Example with an stitched SPE object
if (!exists("spe")) {
    spe <- spatialLIBD::fetch_data(type = "visiumStitched_brain_spe")
}
seur_stitched <- as.Seurat(spe[seq(100), seq(100)])

## Let's look at our resulting Seurat object
seur_stitched
}
\author{
Nicholas J. Eagles
}
