% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msviper.r
\name{msviperSynergy}
\alias{msviperSynergy}
\title{msviper synergy analysis}
\usage{
msviperSynergy(mobj, per = 1000, seed = 1, cores = 1,
  verbose = TRUE)
}
\arguments{
\item{mobj}{msviper object containing combinatorial regulation results generated by \code{msviperCombinatorial}}

\item{per}{Integer indicating the number of permutations}

\item{seed}{Integer indicating the seed for the permutations, 0 for disable it}

\item{cores}{Integer indicating the number of cores to use (only 1 in Windows-based systems)}

\item{verbose}{Logical, whether progression messages should be printed in the terminal}
}
\value{
Updated msviper object containing the sygergy p-value
}
\description{
This function performs a synergy analysis for combinatorial regulation
}
\examples{
data(bcellViper, package="bcellViper")
sig <- rowTtest(dset, "description", c("CB", "CC"), "N")$statistic
dnull <- ttestNull(dset, "description", c("CB", "CC"), "N", per=100) # Only 100 permutations to reduce computation time, but it is recommended to perform at least 1000 permutations
mra <- msviper(sig, regulon, dnull)
mra <- msviperCombinatorial(mra, 20)
mra <- msviperSynergy(mra)
summary(mra)
}
\seealso{
\code{\link{msviper}}
}
