% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aracne.r
\name{aracne2regulon}
\alias{aracne2regulon}
\title{Regulon object generation from ARACNe results}
\usage{
aracne2regulon(afile, eset, gene = FALSE, format = c("adj", "3col"),
  verbose = TRUE)
}
\arguments{
\item{afile}{Character string indicating the name of the ARACNe network file}

\item{eset}{Either a character string indicating the name of the expression-dataset file, a ExpressionSet object or a gene expression matrix with genes (probes) in rows and samples in columns}

\item{gene}{Logical, whether the probes should be collapsed at the gene level}

\item{format}{Character string, indicating the format of the aracne file, either adj for adjacency matrixes generated by aracne, or 3col when the interactome is represented by a 3 columns text file, with regulator in the first column, target in the second and mutual information in the third column}

\item{verbose}{Logical, whether progression messages should be printed in the terminal.}
}
\value{
Regulon object
}
\description{
This function generates a regulon object from ARACNe results and the corresponding expression dataset
}
\examples{
data(bcellViper, package="bcellViper")
adjfile <- file.path(find.package("bcellViper"), "aracne", "bcellaracne.adj")
regul <- aracne2regulon(adjfile, dset)
print(regul)
}
\seealso{
\code{\link{msviper}}, \code{\link{viper}}
}
