% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treat.R
\name{getTreat}
\alias{getTreat}
\alias{getTreat,MArrayLM-method}
\alias{getTreat,MArrayLM2-method}
\title{Test if coefficient is different from a specified value}
\usage{
getTreat(fit, lfc = log2(1.2), coef = 1, number = 10, sort.by = "p")

\S4method{getTreat}{MArrayLM}(fit, lfc = log2(1.2), coef = 1, number = 10, sort.by = "p")

\S4method{getTreat}{MArrayLM2}(fit, lfc = log2(1.2), coef = 1, number = 10, sort.by = "p")
}
\arguments{
\item{fit}{fit}

\item{lfc}{a minimum log2-fold-change below which changes not considered scientifically meaningful}

\item{coef}{which coefficient to test}

\item{number}{number of genes to return}

\item{sort.by}{column to sort by}
}
\value{
results of getTreat
}
\description{
Test if coefficient is different from a specified value
}
\examples{

data(varPartData)

form <- ~ Age + Batch + (1 | Individual) + (1 | Tissue)

fit <- dream(geneExpr, form, info)
fit <- eBayes(fit)

coef <- "Age"

# Evaluate treat()/topTreat() in a way that works seamlessly for dream()
getTreat(fit, lfc = log2(1.03), coef, sort.by = "none", number = 3)

}
