% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tximeta.R
\docType{package}
\name{tximeta-package}
\alias{tximeta-package}
\title{Import transcript quantification with metadata}
\description{
The tximeta package imports abundances (TPM), estimated counts,
and effective lengths from quantification tools,
and will output a \emph{SummarizedExperiment} (SE) object.
For salmon and related quantification tools, \code{\link[=tximeta]{tximeta()}} will
attempt to identify the correct provenance of the reference transcripts
and automatically attach the transcript ranges to the
SummarizedExperiment, to facilitate downstream integration with
other datasets. The automatic identification of reference transcripts
should work out-of-the-box for human or mouse transcriptomes from
the sources: GENCODE, Ensembl, or RefSeq. See also \code{\link[=importData]{importData()}} for
importing data when the reference transcripts were derived from
a mix of annotated (e.g. GENCODE) and novel or custom transcripts.
}
\details{
The main functions are:
\itemize{
\item \code{\link[=tximeta]{tximeta()}} - with key argument \code{coldata} specifying sample information
\item \code{\link[=summarizeToGene,SummarizedExperiment-method]{summarizeToGene()}} - summarize quantification to gene-level
\item \code{\link[=importData]{importData()}} - import quantification with mixed reference transcript sets
}

All software-related questions should be posted to the Bioconductor Support Site:

\url{https://support.bioconductor.org}

The code can be viewed at the GitHub repository,
which also lists the contributor code of conduct:

\url{https://github.com/thelovelab/tximeta}
}
\references{
\itemize{
\item \emph{tximeta} reference:
}

Michael I. Love, Charlotte Soneson, Peter F. Hickey, Lisa K. Johnson
N. Tessa Pierce, Lori Shepherd, Martin Morgan, Rob Patro (2020)
\emph{Tximeta: reference sequence checksums for provenance identification
in RNA-seq}. PLOS Computational Biology.
\url{https://doi.org/10.1371/journal.pcbi.1007664}
\itemize{
\item \emph{tximport} reference (the effective length GLM offset and counts-from-abundance):
}

Charlotte Soneson, Michael I. Love, Mark D. Robinson (2015)
\emph{Differential analyses for RNA-seq: transcript-level estimates
improve gene-level inferences}. F1000Research.
\url{http://doi.org/10.12688/f1000research.7563}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/thelovelab/tximeta}
}

}
\author{
Michael I. Love, Charlotte Soneson, Peter Hickey, Rob Patro
}
\keyword{package}
