% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{txdbToGRangesList}
\alias{txdbToGRangesList}
\title{Convert TxDb object to GRangesList}
\usage{
txdbToGRangesList(
  txdb,
  geneCols = c("gene_id"),
  transcriptCols = c("gene_id", "tx_name"),
  exonCols = c("gene_id", "tx_name", "exon_id", "exon_rank")
)
}
\arguments{
\item{txdb}{a \code{TxDb} object}

\item{geneCols}{names of columns to include in the \code{genes} ranges}

\item{transcriptCols}{names of columns to include in the \code{transcripts} ranges}

\item{exonCols}{names of columns to include in the \code{exons} ranges}
}
\value{
a \code{GRangesList} object with entries \code{c(genes, transcripts, exons)}
}
\description{
Convert TxDb object to GRangesList
}
\examples{
library(TxDb.Scerevisiae.UCSC.sacCer3.sgdGene)

## load annotation
txdb <- TxDb.Scerevisiae.UCSC.sacCer3.sgdGene

grl <- txdbToGRangesList(txdb)
grl

}
