% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plateSummary.R
\name{positiveCounts}
\alias{positiveCounts}
\title{Get a vector of droplet positive and negative counts.}
\usage{
positiveCounts(cl)
}
\arguments{
\item{cl}{A vector of classes that correspond to droplet amplitude data. The
vector should only contain the values "PP", "PN", "NP" or "NN".}
}
\value{
A vector corresponding to "PP", "PN", "NP" and "NN".
}
\description{
Take a vector of classes and return a vector of positive and negative
counts that is compatible with ddPCR analysis.
}
\examples{
## Take a data frame and make it into the right format.
aWell <- KRASdata[["E03"]]
aWell$Cluster <- relabelClasses(aWell, classCol="Cluster")

## Count the number of droplets in each cluster.
positiveCounts(aWell$Cluster)

}
\author{
Anthony Chiu, \email{anthony.chiu@cruk.manchester.ac.uk}
}
