% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\name{set_motifs}
\alias{set_motifs}
\title{Set Transite motif database}
\usage{
set_motifs(value)
}
\arguments{
\item{value}{list of Motif objects}
}
\value{
void
}
\description{
Globally sets Transite motif database, use with care.
}
\examples{
custom_motif <- create_kmer_motif(
  "custom_motif", "RBP1",
  c("AAAAAAA", "CAAAAAA"), "HITS-CLIP",
  "Homo sapiens", "user"
)
set_motifs(list(custom_motif))
}
\seealso{
Other motif functions: 
\code{\link{generate_iupac_by_kmers}()},
\code{\link{generate_iupac_by_matrix}()},
\code{\link{generate_kmers_from_iupac}()},
\code{\link{get_motif_by_id}()},
\code{\link{get_motif_by_rbp}()},
\code{\link{get_motifs}()},
\code{\link{get_motifs_meta_info}()},
\code{\link{get_ppm}()},
\code{\link{init_iupac_lookup_table}()}
}
\concept{motif functions}
