% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{generate_kmers_from_iupac}
\alias{generate_kmers_from_iupac}
\title{Generates all \emph{k}-mers for IUPAC string}
\usage{
generate_kmers_from_iupac(iupac, k)
}
\arguments{
\item{iupac}{IUPAC string}

\item{k}{length of \emph{k}-mer, \code{6} (hexamers) or \code{7} (heptamers)}
}
\value{
list of \emph{k}-mers
}
\description{
Generates all possible \emph{k}-mers for a given IUPAC string.
}
\details{
IUPAC RNA nucleotide code:
\tabular{rl}{
  \code{A} \tab Adenine\cr
  \code{C} \tab Cytosine\cr
  \code{G} \tab Guanine\cr
  \code{U} \tab Uracil\cr
  \code{R} \tab A or G\cr
  \code{Y} \tab C or U\cr
  \code{S} \tab G or C\cr
  \code{W} \tab A or U\cr
  \code{K} \tab G or U\cr
  \code{M} \tab A or C\cr
  \code{B} \tab C or G or U\cr
  \code{D} \tab A or G or U\cr
  \code{H} \tab A or C or U\cr
  \code{V} \tab A or C or G\cr
  \code{N} \tab any base
}
}
\examples{
generate_kmers_from_iupac(get_iupac(get_motif_by_id("M178_0.6")[[1]]), k = 6)
}
\references{
\url{http://www.chem.qmul.ac.uk/iubmb/misc/naseq.html}
}
\seealso{
Other motif functions: 
\code{\link{generate_iupac_by_kmers}()},
\code{\link{generate_iupac_by_matrix}()},
\code{\link{get_motif_by_id}()},
\code{\link{get_motif_by_rbp}()},
\code{\link{get_motifs}()},
\code{\link{get_motifs_meta_info}()},
\code{\link{get_ppm}()},
\code{\link{init_iupac_lookup_table}()},
\code{\link{set_motifs}()}
}
\concept{motif functions}
