% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/k-mer-based.R
\name{calculate_kmer_enrichment}
\alias{calculate_kmer_enrichment}
\title{\emph{k}-mer Enrichment between Foreground and Background Sets}
\usage{
calculate_kmer_enrichment(
  foreground_sets,
  background_set,
  k,
  permutation = FALSE,
  chisq_p_value_threshold = 0.05,
  p_adjust_method = "BH",
  n_cores = 4
)
}
\arguments{
\item{foreground_sets}{list of foreground sets; a foreground set is a
character vector of
DNA or RNA sequences (not both) and a strict subset of the
\code{background_set}}

\item{background_set}{character vector of DNA or RNA sequences that
constitute the
background set}

\item{k}{length of \emph{k}-mer, either \code{6} for hexamers or
\code{7} for heptamers}

\item{permutation}{if \code{TRUE}, only the enrichment value is returned
(efficiency mode
used for permutation testing)}

\item{chisq_p_value_threshold}{threshold below which Fisher's exact test
is used instead of Pearson's chi-squared test}

\item{p_adjust_method}{see \code{\link[stats]{p.adjust}}}

\item{n_cores}{number of computing cores to use}
}
\value{
A list with three entries:
\tabular{rl}{
  \code{dfs} \tab a list of data frames with results from
  \code{\link{compute_kmer_enrichment}} for each of the foreground sets\cr
  \code{kmers} \tab a character vector of all k-mers\cr
  \code{kmer_origins} \tab a list of k-mers and their original sequence(s)
}
}
\description{
Calls \code{\link{compute_kmer_enrichment}} to compute \emph{k}-mer
enrichment values
for multiple foregrounds. Calculates enrichment for foreground sets in
parallel.
}
\examples{
# define simple sequence sets for foreground and background
foreground_set1 <- c(
  "CAACAGCCUUAAUU", "CAGUCAAGACUCC", "CUUUGGGGAAU",
  "UCAUUUUAUUAAA", "AAUUGGUGUCUGGAUACUUCCCUGUACAU",
  "AUCAAAUUA", "AGAU", "GACACUUAAAGAUCCU",
  "UAGCAUUAACUUAAUG", "AUGGA", "GAAGAGUGCUCA",
  "AUAGAC", "AGUUC", "CCAGUAA"
)
foreground_set2 <- c("UUAUUUA", "AUCCUUUACA", "UUUUUUU", "UUUCAUCAUU")
foreground_sets <- list(foreground_set1, foreground_set2)
background_set <- c(foreground_set1, foreground_set2,
                    "CCACACAC", "CUCAUUGGAG", "ACUUUGGGACA", "CAGGUCAGCA")

# single-threaded
kmer_enrichment_values_st <- calculate_kmer_enrichment(foreground_sets,
  background_set, 6, n_cores = 1)
\dontrun{
# multi-threaded
kmer_enrichment_values_mt <- calculate_kmer_enrichment(foreground_sets,
  background_set, 6)}
}
\seealso{
Other \emph{k}-mer functions: 
\code{\link{check_kmers}()},
\code{\link{compute_kmer_enrichment}()},
\code{\link{count_homopolymer_corrected_kmers}()},
\code{\link{create_kmer_origin_list}()},
\code{\link{draw_volcano_plot}()},
\code{\link{estimate_significance}()},
\code{\link{estimate_significance_core}()},
\code{\link{generate_kmers}()},
\code{\link{generate_permuted_enrichments}()},
\code{\link{run_kmer_spma}()},
\code{\link{run_kmer_tsma}()}
}
\concept{\emph{k}-mer functions}
