% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChipDataSet-generics.R, R/ChipDataSet-methods.R
\docType{methods}
\name{addFeature}
\alias{addFeature}
\alias{addFeature,ChipDataSet-method}
\title{addFeature}
\usage{
addFeature(object, feature)

\S4method{addFeature}{ChipDataSet}(object, feature)
}
\arguments{
\item{object}{A \code{\link{ChipDataSet}} object.}

\item{feature}{\code{List}. User specified characteristics of the peaks.}
}
\value{
The user specified feature(s) will be added to the slot \code{features}
    of the provided  \code{\link{ChipDataSet}} object.
}
\description{
Add feature(s) to the \code{\link{ChipDataSet}} object.
}
\examples{
### Load ChipDataSet object
data(cds)

### As an example create some fake data
N <- length(getPeaks(cds))
fake.data <- rnorm(n = N)

addFeature(object = cds, feature = list(fake = fake.data))

### View newly added feature
getPeaks(cds)

}
\author{
Armen R. Karapetyan
}
\seealso{
\code{\link{constructCDS}} \code{\link{predictTssOverlap}}
}

