% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/predictCells.R
\name{predictCells}
\alias{predictCells}
\alias{predictCells,SingleCellExperiment-method}
\alias{predictCells,list-method}
\title{predictCells}
\usage{
predictCells(models, ...)

\S4method{predictCells}{SingleCellExperiment}(models, gene)

\S4method{predictCells}{list}(models, gene)
}
\arguments{
\item{models}{Either the \code{SingleCellExperiment} object obtained after
running \code{fitGAM}, or the specific GAM model for the corresponding gene,
if working with the list output of \code{tradeSeq}.}

\item{...}{parameters including:}

\item{gene}{Gene name of gene for which to extract fitted values.}
}
\value{
A vector of fitted values.
}
\description{
Get fitted values for each cell.
}
\details{
Using the gene expression model of \code{tradeSeq} available at
\url{https://www.nature.com/articles/s41467-020-14766-3#Sec2}.
the output of \code{predictCells} returns the \eqn{\eta_{gi}} value for each cell.
}
\examples{
data(gamList, package = "tradeSeq")
predictCells(models = gamList, gene = 1)
}
