% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plotGeneCount.R
\name{plotGeneCount}
\alias{plotGeneCount}
\alias{plotGeneCount,SlingshotDataSet-method}
\alias{plotGeneCount,PseudotimeOrdering-method}
\alias{plotGeneCount,SingleCellExperiment-method}
\title{Plot gene expression in reduced dimension.}
\usage{
plotGeneCount(curve, ...)

\S4method{plotGeneCount}{SlingshotDataSet}(
  curve,
  counts = NULL,
  gene = NULL,
  clusters = NULL,
  models = NULL,
  title = NULL
)

\S4method{plotGeneCount}{PseudotimeOrdering}(
  curve,
  counts = NULL,
  gene = NULL,
  clusters = NULL,
  models = NULL,
  title = NULL
)

\S4method{plotGeneCount}{SingleCellExperiment}(
  curve,
  counts = NULL,
  gene = NULL,
  clusters = NULL,
  models = NULL,
  title = NULL
)
}
\arguments{
\item{curve}{One of the following:
\itemize{
\item A \code{PseudotimeOrdering} or \code{\link{SlingshotDataSet}} object.
The output from trajectory inference using Slingshot.
 \item A \code{\link{SingleCellExperiment}} object. The output from trajectory inference
using Slingshot. 
\item A \code{CellDataset} object.
}}

\item{...}{parameters including:}

\item{counts}{The count matrix, genes in rows and cells in columns. Only
needed if the input is of the type \code{PseudotimeOrdering} or
\code{\link{SlingshotDataSet}} and the \code{gene} argument is not
\code{NULL}.}

\item{gene}{The name of gene for which you want to plot the count or the row
number of that gene in the count matrix. Alternatively, one can specify
the \code{clusters} argument.}

\item{clusters}{The assignation of each cell to a cluster. Used to color the
plot. Either \code{clusters} or \code{gene} and \code{counts} must be supplied.}

\item{models}{The fitted GAMs, typically the output from
\code{\link{fitGAM}}. Used to display the knots. Does not work with a 
\code{CellDataset} object as input.}

\item{title}{Title for the plot.}
}
\value{
A \code{\link{ggplot}} object
}
\description{
Plot the gene in reduced dimensional space.
}
\details{
If both \code{gene} and \code{clusters} arguments are supplied, the
 plot will be colored according to gene count level. If none are provided, the 
 function will fail.
}
\examples{
set.seed(97)
library(slingshot)
data(crv, package="tradeSeq")
data(countMatrix, package="tradeSeq")
rd <- slingReducedDim(crv)
cl <- kmeans(rd, centers = 7)$cluster
lin <- getLineages(rd, clusterLabels = cl, start.clus = 4)
crv <- getCurves(lin)
counts <- as.matrix(countMatrix)
gamList <- fitGAM(counts = counts,
 pseudotime = slingPseudotime(crv, na = FALSE),
 cellWeights = slingCurveWeights(crv))
plotGeneCount(crv, counts, gene = "Mpo")
}
