% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allclasses.R
\docType{class}
\name{trackStyle-class}
\alias{trackStyle-class}
\alias{trackStyle}
\alias{track-class}
\alias{track}
\alias{seqlevels,track-method}
\alias{seqlevelsStyle,track-method}
\alias{seqlevelsStyle<-,track-method}
\alias{show,track-method}
\alias{$,track-method}
\alias{$,trackStyle-method}
\alias{$<-,track-method}
\alias{$<-,trackStyle-method}
\alias{setTrackStyleParam}
\alias{setTrackStyleParam,track,character-method}
\alias{setTrackStyleParam,track,character,ANY-method}
\alias{setTrackXscaleParam}
\alias{setTrackXscaleParam,track,character-method}
\alias{setTrackXscaleParam,track,character,ANY-method}
\alias{setTrackYaxisParam}
\alias{setTrackYaxisParam,track,character-method}
\alias{setTrackYaxisParam,track,character,ANY-method}
\title{Class \code{"trackStyle"}}
\usage{
\S4method{seqlevels}{track}(x)

\S4method{seqlevelsStyle}{track}(x)

\S4method{seqlevelsStyle}{track}(x) <- value

\S4method{show}{track}(object)

\S4method{$}{track}(x, name)

\S4method{$}{track}(x, name) <- value

setTrackStyleParam(ts, attr, value)

\S4method{setTrackStyleParam}{track,character}(ts, attr, value)

setTrackXscaleParam(ts, attr, value)

\S4method{setTrackXscaleParam}{track,character}(ts, attr, value)

setTrackYaxisParam(ts, attr, value)

\S4method{setTrackYaxisParam}{track,character}(ts, attr, value)
}
\arguments{
\item{x}{an object of trackStyle or track}

\item{value}{values to be assigned.}

\item{object}{an object of trackStyle.}

\item{name}{slot name of trackStyle or track}

\item{ts}{An object of \code{track}.}

\item{attr}{the name of slot of \code{\link{trackStyle}} object to be changed.}
}
\description{
An object of class \code{"trackStyle"} represents track style.

An object of class \code{"track"} represents scores of a given track.
}
\details{
The attr of \code{setTrackXscaleParam} could not only be a slot of xscale, but also be position.
If the attr is set to position, value must be a list of x, y and label. For example
setTrackXscaleParam(track, attr="position", value=list(x=122929675, y=4, label=500))
}
\section{Slots}{

\describe{
\item{\code{tracktype}}{\code{"character"} track type, could be peak, 
line, histogram, or annotation. 
Default is "peak". "annotation" is used to mark the peak regions.
For interaction data,
it could be "heatmap" or "link".}

\item{\code{color}}{\code{"character"} track color. If the track has dat and dat2 slot,
it should have two values.}

\item{\code{NAcolor}}{\code{"character"} NA color for interactionData.}

\item{\code{breaks}}{\code{"numeric"} breaks for color keys of interactionData.}

\item{\code{height}}{\code{"numeric"} track height. It should be a value between 0 and 1}

\item{\code{marginTop}}{\code{"numeric"} track top margin}

\item{\code{marginBottom}}{\code{"numeric"} track bottom margin}

\item{\code{xscale}}{object of \code{\link{xscale}}, describe the details of x-scale}

\item{\code{yaxis}}{object of \code{\link{yaxisStyle}}, describe the details of y-axis}

\item{\code{ylim}}{\code{"numeric"} y-axis range}

\item{\code{ylabpos}}{\code{"character"}, ylable postion, ylabpos should 
be 'left', 'right', 'topleft', 'bottomleft', 'topright', 'bottomright',
'abovebaseline', 'underbaseline', or 'none'.
For gene type track, it also could be 'upstream' or 'downstream'}

\item{\code{ylablas}}{\code{"numeric"} y lable direction. It should 
be a integer 0-3. See \code{\link[graphics]{par}:las}}

\item{\code{ylabgp}}{A \code{"list"} object, It will convert to an object of 
class \code{\link[grid]{gpar}}. This is basically a list of graphical 
parameter settings of y-label.}

\item{\code{ysplit}}{A \code{"numeric"} to split y plot region for interaction data.
Default is 0.5, which will split the region half to half. It will only work
for back to back plot.}

\item{\code{dat}}{Object of class \code{\link[GenomicRanges:GRanges-class]{GRanges}}
the scores of a given track. It should contain score metadata.}

\item{\code{dat2}}{Object of class \code{\link[GenomicRanges:GRanges-class]{GRanges}}
the scores of a given track. It should contain score metadata. When dat2
and dat is paired, dat will be drawn as positive value where dat2 will be 
drawn as negative value (-1 * score)}

\item{\code{type}}{The type of track. It could be 'data', 'gene', 'transcript', 'scSeq', 'lollipopData' or 'interactionData'.}

\item{\code{format}}{The format of the input. It could be "BED", "bedGraph",
"WIG", "BigWig" or "BAM"}

\item{\code{style}}{Object of class \code{\link{trackStyle}}}

\item{\code{name}}{unused yet}
}}

\examples{
extdata <- system.file("extdata", package="trackViewer",
mustWork=TRUE)
fox2 <- importScore(file.path(extdata, "fox2.bed"), format="BED")
setTrackStyleParam(fox2, "color", c("red","green"))
setTrackXscaleParam(fox2, "gp", list(cex=.5))
setTrackYaxisParam(fox2, "gp", list(col="blue"))
fox2$dat <- GRanges(score=numeric(0))
}
\seealso{
Please try to use \code{\link{importScore}} and \code{\link{importBam}} to 
generate the object.
}
