% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRoperator.R
\name{GRoperator}
\alias{GRoperator}
\title{GRanges operator}
\usage{
GRoperator(
  A,
  B,
  col = "score",
  operator = c("+", "-", "*", "/", "^", "\%\%"),
  ignore.strand = TRUE
)
}
\arguments{
\item{A}{an object of GRanges}

\item{B}{an object of GRanges}

\item{col}{colname of A and B to be calculated}

\item{operator}{operator, "+" means A + B, and so on. 
User-defined function also could be used.}

\item{ignore.strand}{When set to TRUE, the strand information is 
ignored in the overlap calculations.}
}
\value{
an object of GRanges
}
\description{
GRanges operations (add, aubtract, multiply, divide)
}
\examples{
gr2 <- GRanges(seqnames=c("chr1", "chr1"),
ranges=IRanges(c(7,13), width=3),
strand=c("-", "-"), score=3:4)
gr3 <- GRanges(seqnames=c("chr1", "chr1"),
               ranges=IRanges(c(1, 4), c(3, 9)),
               strand=c("-", "-"), score=c(6L, 2L))
GRoperator(gr2, gr3, col="score", operator="+")
GRoperator(gr2, gr3, col="score", operator="-")
GRoperator(gr2, gr3, col="score", operator="*")
GRoperator(gr2, gr3, col="score", operator="/")
GRoperator(gr2, gr3, col="score", operator=mean)
}
