# trackViewer

[![DOI](https://img.shields.io/badge/DOI-10.1038%2Fs41592--019--0430--y-brightgreen.svg)](https://doi.org/10.1038/s41592-019-0430-y)
[![platforms](http://bioconductor.org/shields/availability/devel/trackViewer.svg)](http://bioconductor.org/packages/devel/bioc/html/trackViewer.html)
[![build](http://bioconductor.org/shields/build/devel/bioc/trackViewer.svg)](http://bioconductor.org/packages/devel/bioc/html/trackViewer.html)

A R/Bioconductor package for drawing elegant interactive tracks or lollipop plot to facilitate integrated analysis of multi-omics data

Visualize mapped reads along with annotation as track layers for NGS dataset 
  such as ChIP-seq, RNA-seq, miRNA-seq, DNA-seq, SNPs and methylation data.

## Installation

To install this package, start R and enter:

```r
library(BiocManager)
BiocManager::install("trackViewer")
```

## Documentation

To view documentation of trackViewer, start R and enter:
```r
browseVignettes("trackViewer")
```

Or view it online at:
https://bioconductor.org/packages/release/bioc/vignettes/trackViewer/inst/doc/trackViewer.html

## Citation

Please cite the paper below for the trackViewer package.

  Ou J. Zhu L. trackViewer: a Bioconductor package for interactive and
  integrative visualization of multi-omics data. Nature Methods 16, 453–454
  (2019)
  
