% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/functions-FragmentViews.R,
%   R/methods-FragmentViews.R
\docType{class}
\name{FragmentViews-class}
\alias{FragmentViews-class}
\alias{FragmentViews}
\alias{combine,FragmentViews,FragmentViews-method}
\alias{combine,FragmentViews-method}
\alias{mz,FragmentViews-method}
\alias{show,FragmentViews-method}
\alias{coerce,FragmentViews,data.frame-method}
\title{The FragmentViews class}
\usage{
FragmentViews(
  sequence,
  mass,
  type,
  z = 1L,
  start = NULL,
  end = NULL,
  width = NULL,
  names = NULL,
  metadata = list()
)

\S4method{combine}{FragmentViews,FragmentViews}(x, y)

\S4method{mz}{FragmentViews}(object, ...)

\S4method{show}{FragmentViews}(object)
}
\arguments{
\item{sequence}{\code{character}/
\link[Biostrings:AAString-class]{Biostrings::AAString},
complete protein/peptide sequence.}

\item{mass}{\code{double},
mass of the fragments, same length as \code{start}/\code{end}/\code{width}.}

\item{type}{\code{character},
type of the fragments, same length as \code{start}/\code{end}/width`.}

\item{z}{\code{integer},
charge of the fragments,
length one or same length as \code{start}/\code{end}/width`.}

\item{start}{\code{integer},
start positions of the fragments. At least two of
\code{start}/\code{end}/width` has to be given.}

\item{end}{\code{integer},
end positions of the fragments. At least two of
\code{start}/\code{end}/width` has to be given.}

\item{width}{\code{integer},
width positions of the fragments. At least two of
\code{start}/\code{end}/width` has to be given.}

\item{names}{\code{character},
names of the fragments, same length as \code{start}/\code{end}/width`.}

\item{metadata}{\code{list}, metadata like modifications.}

\item{object, x, y}{FragmentViews}

\item{\ldots}{arguments passed to internal/other methods.}
}
\value{
An \linkS4class{FragmentViews} object.
}
\description{
The FragmentViews class is a basic container for storing a set of views
(start/end locations) on the same peptides/protein sequence. Additionally
it keeps information about mass, type and charge of the fragments.
}
\details{
FragmentViews extends
\link[Biostrings:XStringViews-class]{Biostrings::XStringViews}.
In short it combines an
\link[IRanges:IRanges-class]{IRanges::IRanges}
object to store start/end
location on a sequence, an
\link[Biostrings:AAString-class]{Biostrings::AAString} object.
}
\section{Functions}{
\itemize{
\item \code{FragmentViews()}: Constructor

In general it is not necessary to call the constructor manually. See
\code{\link[=readTopDownFiles]{readTopDownFiles()}} instead.

}}
\section{Coercion}{


\code{as(object, "data.frame")}: Coerce an
\linkS4class{FragmentViews} object into a \code{data.frame}.
}

\examples{
# Constructor
fv <- FragmentViews("ACE", start=1, width=1:3, names=paste0("b", 1:3),
                    mass=c(72.04439, 232.07504, 361.11763),
                    type="b", z=1)
fv

# Coercion to data.frame
as(fv, "data.frame")
as(fv, "data.frame")
}
\seealso{
\link[Biostrings:XStringViews-class]{Biostrings::XStringViews}
}
\author{
Sebastian Gibb \email{mail@sebastiangibb.de}
}
