% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{normalizeTomo}
\alias{normalizeTomo}
\title{Normalize data}
\usage{
normalizeTomo(object, method = "median")
}
\arguments{
\item{object}{A \code{SummarizedExperiment} object.}

\item{method}{Character, must be one of \code{"median"}, or \code{"cpm"}.}
}
\value{
A \code{SummarizedExperiment} object with normalized read count matrix saved in assay \code{'normalized'}.
}
\description{
Normalize the raw read count in a \code{SummarizedExperiment} object.
}
\details{
This function should be run for \code{SummarizedExperiment} object created from raw read count matrix.
If the \code{SummarizedExperiment} object already has a normalized count matrix. The function simply return the original object.
Library sizes of all sections are normalized to the median library size (method='median') or one million (method='cpm').
}
\examples{
data(zh.data)
zh <- createTomo(zh.data, normalize=FALSE)
zh <- normalizeTomo(zh)
}
