% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{geneEmbedPlot}
\alias{geneEmbedPlot}
\title{Embedding plot for genes}
\usage{
geneEmbedPlot(object, gene.df, group = "center", method = "TSNE")
}
\arguments{
\item{object}{A \code{SummarizedExperiment} object.}

\item{gene.df}{Data.frame. The first column must be a vector of gene names, and has the name \code{"gene"}. Additional columns in \code{gene.df} can be used to set the colors of genes.}

\item{group}{Character, a column name in \code{gene.df} defining the groups of genes. Genes in the same group have same colors.}

\item{method}{Character, the embeddings for scatter plot. Must be one of \code{"TSNE"}, \code{"UMAP"}, or \code{"PCA"}.}
}
\value{
A \code{ggplot} object.
}
\description{
Scatter plot for genes with two-dimenstional embeddings in a \code{SummarizedExperiment} object. Each point stands for a gene.
}
\examples{
data(zh.data)
zh <- createTomo(zh.data)
peak_genes <- findPeakGene(zh)
zh <- runTSNE(zh, peak_genes$gene)
# Color genes by peak centers.
geneEmbedPlot(zh, peak_genes)

# Color genes by peak starts.
geneEmbedPlot(zh, peak_genes, group="start")

# Do not color genes.
geneEmbedPlot(zh, peak_genes["gene"])
}
