% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{findPeak}
\alias{findPeak}
\title{Find peak in a vector}
\usage{
findPeak(x, threshold = 1, length = 4)
}
\arguments{
\item{x}{A numeric vector.}

\item{threshold}{Integer, only values bigger than \code{threshold} are recognized as part of the peak.}

\item{length}{Integer, minimum \code{length} of consecutive values bigger than \code{threshold} are recognized as a peak.}
}
\value{
A numeric vector. The first element is the start index and the second element is the end index of the peak.
If multiple peaks exist, only output the start and end index of the one with maximun length.
If no peak exist, return \code{c(0, 0)}.
}
\description{
Find the position of peak in a vector.
}
\examples{
# return c(3, 10)
findPeak(c(0:5, 5:0), threshold=1, length=4)

# Most likely return c(0, 0)
findPeak(rnorm(10), threshold=3, length=3)
}
