% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_df.R
\name{as_df}
\alias{as_df}
\title{Create a dataframe for the type of entity selected}
\usage{
as_df(sbml_list_listOf)
}
\arguments{
\item{sbml_list_listOf}{sbml converted into a list restricted to a 'listOf' level (e.g. listOfSpecies), a list}
}
\value{
one dataframe (or a list of two dataframes) containing information about the entities in the input list
}
\description{
It takes in input a sbml-converted list zoomed at one 'listOf' level and produces one dataframe containing one row for each entity (i.e. either species, reaction or compartment) and columns for the attributes, notes and annotation content.
}
\details{
Input list may be obtained using sbml_as_list() with the argument 'component' equal to 'species', 'reactions' or 'compartments', which returns a list zoomed at 'listOfSpecies', 'listOfReactions' or 'listOfCompartments' level, respectively.
If the 'listOf' selected is 'listOfReactions' it returns one more dataframe: the first one with one row for each reaction, and the extra one with one row for each species involved in each reaction (i.e. entities called 'speciesReference' in the sbml).
Each dataframe contains at least one column, since some attributes are mandatory, and also notes and annotation columns, if their content is not empty. If the dataframe is missing it means the sbml does not contain such information (i.e. no data about those entities).
}
\examples{
filepath <- system.file("extdata", "R-HSA-8937144.sbml", package = "tidysbml")

sbml_list <- sbml_as_list(filepath, "species")
df <- as_df(sbml_list) ## returns one dataframe with data about the species saved in the sbml document

sbml_list <- sbml_as_list(filepath, "reactions")
df <- as_df(sbml_list) ## returns one list containing two dataframe with data about the reactions and the speciesReferences listed in the sbml document
}
