% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_methods.R
\name{count}
\alias{count}
\alias{count.SummarizedExperiment}
\title{Count the observations in each group}
\usage{
\method{count}{SummarizedExperiment}(
  x,
  ...,
  wt = NULL,
  sort = FALSE,
  name = NULL,
  .drop = group_by_drop_default(x)
)
}
\arguments{
\item{x}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr).}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Variables to group
by.}

\item{wt}{<\code{\link[rlang:args_data_masking]{data-masking}}> Frequency weights.
Can be \code{NULL} or a variable:
\itemize{
\item If \code{NULL} (the default), counts the number of rows in each group.
\item If a variable, computes \code{sum(wt)} for each group.
}}

\item{sort}{If \code{TRUE}, will show the largest groups at the top.}

\item{name}{The name of the new column in the output.

If omitted, it will default to \code{n}. If there's already a column called \code{n},
it will use \code{nn}. If there's a column called \code{n} and \code{nn}, it'll use
\code{nnn}, and so on, adding \code{n}s until it gets a new name.}

\item{.drop}{Handling of factor levels that don't appear in the data, passed
on to \code{\link[dplyr:group_by]{group_by()}}.

For \code{count()}: if \code{FALSE} will include counts for empty groups (i.e. for
levels of factors that don't exist in the data).

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} For \code{add_count()}: deprecated since it
can't actually affect the output.}
}
\value{
An object of the same type as \code{.data}. \code{count()} and \code{add_count()}
group transiently, so the output has the same groups as the input.
}
\description{
\code{count()} lets you quickly count the unique values of one or more variables:
\code{df \%>\% count(a, b)} is roughly equivalent to
\code{df \%>\% group_by(a, b) \%>\% summarise(n = n())}.
\code{count()} is paired with \code{tally()}, a lower-level helper that is equivalent
to \code{df \%>\% summarise(n = n())}. Supply \code{wt} to perform weighted counts,
switching the summary from \code{n = n()} to \code{n = sum(wt)}.

\code{add_count()} and \code{add_tally()} are equivalents to \code{count()} and \code{tally()}
but use \code{mutate()} instead of \code{summarise()} so that they add a new column
with group-wise counts.
}
\examples{
data(se)
se |> count(dex)
    
}
\references{
Hutchison, W.J., Keyes, T.J., The tidyomics Consortium. et al. The tidyomics ecosystem: enhancing omic data analyses. Nat Methods 21, 1166–1170 (2024). https://doi.org/10.1038/s41592-024-02299-2

Wickham, H., François, R., Henry, L., Müller, K., Vaughan, D. (2023). dplyr: A Grammar of Data Manipulation. R package version 2.1.4, https://CRAN.R-project.org/package=dplyr
}
