% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyr_verbs.R
\name{unnest.flowSet}
\alias{unnest.flowSet}
\title{Unnest a \code{\link[flowCore]{flowSet}} into a single
\code{\link[flowCore]{flowFrame}}}
\usage{
\method{unnest}{flowSet}(
  data,
  cols,
  ...,
  keep_empty = FALSE,
  ptype = NULL,
  names_sep = NULL,
  names_repair = "check_unique"
)
}
\arguments{
\item{data}{A \code{\link[flowCore]{flowSet}}}

\item{cols}{Columns in \code{\link[Biobase]{pData}} to unnest.}

\item{...}{Unused.}

\item{keep_empty}{Unused.}

\item{ptype}{Unused.}

\item{names_sep}{Unused.}

\item{names_repair}{Unused.}
}
\value{
A \code{\link[flowCore]{flowFrame}} or \code{\link[flowCore]{flowSet}}
depending on the degree of unnest-ing. Note that unnest-ing and
ungrouping a \code{\link[flowCore]{flowSet}} are equivalent.
}
\description{
Unnest a \code{\link[flowCore]{flowSet}} into a single
\code{\link[flowCore]{flowFrame}}
}
\examples{
my_flowset <- simulate_cytometry_data()$flowset

my_flowset |>
  tidyr::unnest(cols = c(patient, cell_type))

my_flowset |>
  tidyr::unnest(cols = patient)

}
