% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{test_predictions}
\alias{test_predictions}
\title{Test the ECDF ranks of groups are from same distribution}
\usage{
test_predictions(rank, group, compare, ...)
}
\arguments{
\item{rank}{A numeric vector}

\item{group}{A factor of length equal that of rank}

\item{compare}{A character vector of length two}

\item{...}{Other arguments passed to ks.test}
}
\value{
An htest object
}
\description{
Test whether the cumulative distribution function of two groups are drawn
from the same distribution.
}
\examples{
# generate random values
rn1 <- rnorm(100)
rn2 <- rnorm(100, 2)
e <- c(rn1, rn2)

# generate grouping variable
g <- rep(c('up', 'down'), times = c(length(rn1), length(rn2)))

# test
test_predictions(e,
                 group = g,
                 compare = c('up', 'down'))

}
