% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/tRNA-subset.R
\name{hasTStem}
\alias{hasTStem}
\alias{hasDStem}
\alias{hasAcceptorStem}
\alias{hasAnticodonStem}
\alias{hasTloop}
\alias{hasDloop}
\alias{hasAnticodonLoop}
\alias{hasVariableLoop}
\alias{tRNA-subset}
\alias{hasTStem,GRanges-method}
\alias{hasDStem,GRanges-method}
\alias{hasAcceptorStem,GRanges-method}
\alias{hasAnticodonStem,GRanges-method}
\alias{hasTloop,GRanges-method}
\alias{hasDloop,GRanges-method}
\alias{hasAnticodonLoop,GRanges-method}
\alias{hasVariableLoop,GRanges-method}
\title{Subsetting tRNAs}
\usage{
hasTStem(x, length = NA, unpaired = NA, mismatches = NA, bulged = NA)

hasDStem(x, length = NA, unpaired = NA, mismatches = NA, bulged = NA)

hasAcceptorStem(x, length = NA, unpaired = NA, mismatches = NA, bulged = NA)

hasAnticodonStem(x, length = NA, unpaired = NA, mismatches = NA, bulged = NA)

hasTloop(x, length = NA)

hasDloop(x, length = NA)

hasAnticodonLoop(x, length = NA)

hasVariableLoop(x, length = NA, paired = NA, mismatches = NA, bulged = NA)

\S4method{hasTStem}{GRanges}(x, length = NA, unpaired = NA, mismatches = NA, bulged = NA)

\S4method{hasDStem}{GRanges}(x, length = NA, unpaired = NA, mismatches = NA, bulged = NA)

\S4method{hasAcceptorStem}{GRanges}(x, length = NA, unpaired = NA, mismatches = NA, bulged = NA)

\S4method{hasAnticodonStem}{GRanges}(x, length = NA, unpaired = NA, mismatches = NA, bulged = NA)

\S4method{hasTloop}{GRanges}(x, length = NA)

\S4method{hasDloop}{GRanges}(x, length = NA)

\S4method{hasAnticodonLoop}{GRanges}(x, length = NA)

\S4method{hasVariableLoop}{GRanges}(x, length = NA, paired = NA, mismatches = NA, bulged = NA)
}
\arguments{
\item{x}{a GRanges object from a tRNAscan import or with equivalent
information}

\item{length}{the length as integer}

\item{unpaired}{logical: has unpaired nucleotides}

\item{mismatches}{logical: has mismatched nucleotides}

\item{bulged}{logical: has mismatched nucleotides of different length
creating a bulge}

\item{paired}{logical: has paired nucleotides (only used for loops)}
}
\value{
a logical vector of the length or input GRanges object
}
\description{
The functions \code{has*} can be used to subset the GRanges object containing
information about tRNAs.

Please not that the settings \code{mismatches} and \code{bulged} take
precedence before \code{unpaired} or \code{paired}. This means that by
setting either \code{mismatches} or \code{bulged} to either \code{TRUE} or
\code{FALSE}, \code{unpaired = TRUE} or \code{paired = TRUE} are
automatically set to allow specific subsetting. If this removes elements from
the results, please consider constructing a logical vectors with two calls as
suggested in the examples.
}
\examples{
data("gr", package = "tRNA")
hasTStem(gr, length = 5, mismatches = TRUE)
gr[hasTStem(gr, length = 5, mismatches = TRUE)]
gr[hasDStem(gr, unpaired = FALSE) & hasDStem(gr, mismatches = FALSE)]
}
