% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/tRNA-plot.R
\name{gettRNAFeaturePlots}
\alias{gettRNAFeaturePlots}
\alias{gettRNAFeaturePlots,GRangesList-method}
\title{Graphical summary of tRNA features}
\usage{
gettRNAFeaturePlots(x, plotScores = FALSE, scores = NA, scoreLabel = "Score")

\S4method{gettRNAFeaturePlots}{GRangesList}(x, plotScores = FALSE, scores = NA, scoreLabel = "Score")
}
\arguments{
\item{x}{a named GRangesList object.}

\item{plotScores}{logical value, whether to plot scores. If scores are not
provided with an additional argument, it will try to use the column "score"
of the GRanges objects.}

\item{scores}{a list of scores, which have to have the same dimensions as the
GRangesList or GRanges object.}

\item{scoreLabel}{a string to use as a label for the x axis.}
}
\value{
a list of ggplot2 plots. These can be customized further.
}
\description{
\code{gettRNAFeaturePlots} generates a plot for every feature found with
\code{gettRNASummary}. Based on the datatype, it will generate suitable point
or bar plots. Names of the GRangesList will be used as sample identifiers
and used for colouring.

The options \code{tRNA_colour_palette}, \code{tRNA_colour_yes} and
\code{tRNA_colour_no} will be used for colours.
}
\examples{
data("gr", package = "tRNA")
data("gr_eco", package = "tRNA")
grl <- GRangesList(Sce = gr,
                   Eco = gr_eco)
plots <- gettRNAFeaturePlots(grl)

# customized plots
plots$length$layers <- plots$length$layers[c(-1,-2)]
plots$length + ggplot2::geom_boxplot()
}
