% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLMplot.R
\name{GLMplot}
\alias{GLMplot}
\title{Dimension Reduction with GLMplot}
\usage{
GLMplot(
  exploredds,
  L = 2,
  plotly = FALSE,
  savePlot = FALSE,
  filePlot = NULL,
  ...
)
}
\arguments{
\item{exploredds}{object of class \code{\link[DESeq2:DESeqDataSet]{DESeq2::DESeqDataSet()}}, generated from
\code{exploreDDS} function.}

\item{L}{desired number of latent dimensions (positive integer).}

\item{plotly}{logical: when \code{FALSE} (default), the \code{ggplot2} plot will be
returned. \code{TRUE} option returns the \code{plotly} version of the plot.}

\item{savePlot}{logical: when \code{FALSE} (default), the plot will not be saved.
If \code{TRUE} the plot will be saved, and requires the \code{filePlot} argument.}

\item{filePlot}{file name where the plot will be saved. For more information,
please consult the \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}} function.}

\item{...}{additional parameters for the \code{\link[glmpca:glmpca]{glmpca::glmpca()}} function.}
}
\value{
returns an object of \code{ggplot} or \code{plotly} class.
}
\description{
This function computes and plots generalized principal
components analysis for dimension reduction of count expression matrix.
}
\examples{
## Targets file
targetspath <- system.file("extdata", "targets.txt", package = "systemPipeR")
targets <- read.delim(targetspath, comment = "#")
cmp <- systemPipeR::readComp(file = targetspath, format = "matrix", 
delim = "-")
## Count table file
countMatrixPath <- system.file("extdata", "countDFeByg.xls", 
package = "systemPipeR")
countMatrix <- read.delim(countMatrixPath, row.names = 1)
## Plot
exploredds <- exploreDDS(countMatrix, targets, cmp = cmp[[1]], 
preFilter = NULL, transformationMethod = "raw")
GLMplot(exploredds, plotly = FALSE)
}
\references{
F. William Townes and Kelly Street (2020). glmpca: Dimension Reduction of
Non-Normally Distributed Data. R package version 0.2.0.
\url{https://CRAN.R-project.org/package=glmpca}
}
\keyword{visualization}
