% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spsUIcollections.R
\name{genHrefTable}
\alias{genHrefTable}
\title{Generate a table that lists tabs by rows}
\usage{
genHrefTable(
  rows,
  Id = NULL,
  title = "A Table to list tabs",
  text_color = "#0275d8",
  app_path = NULL,
  ...
)
}
\arguments{
\item{rows}{a named list of character vector, the item names in the list
will be the row names and each item should be a vector of tab IDs.
Or you can use one of 'core', 'wf', 'vs', 'data', 'plot' to specify a tab
type, so it will find
all tabs matching that type. See \code{tab_info.csv} under \code{config} directory for
type info.}

\item{Id}{element ID}

\item{title}{table title}

\item{text_color}{text color for table}

\item{app_path}{app path, default is current working directory}

\item{...}{any additional arguments to the html element, like class, style...}
}
\value{
HTML elements
}
\description{
A fast way in SPS to generate a table that lists some SPS tabs
}
\details{
For \code{rows}, there are some specially reserved characters
for type and sub-types, one of c('core', 'wf', 'vs', 'data', 'plot').
If indicated, it will return a list of tabs matching
the indicated tabs instead of searching individual tab names. See examples.

This function requires a SPS project and the config/tabs.csv file.
If you want to use hrefTable outside a SPS project, or want to create some
links pointing to outside web resources, use \link[spsComps:hrefTable]{spsComps::hrefTable}
}
\examples{
if(interactive()){
    spsInit()
    # will be two rows, one row is searched by tab IDs and the other is
    # searched by type.
    rows <- list(row1 = c("core_canvas", "core_about"),
                 row2 =  "data")
    ui <- fluidPage(
        genHrefTable(rows)
    )
    server <- function(input, output, session) {

    }
    shinyApp(ui, server)
}
}
