% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas.R
\name{canvasBtn}
\alias{canvasBtn}
\title{Screenshot a plot or UI to SPS Canvas or download as an image}
\usage{
canvasBtn(dom, id = "", isID = TRUE, class = "text-center", placement = "top")
}
\arguments{
\item{dom}{a HTML DOM selector, mostly common is to select the element by ID:

e.g. a plot with ID "plot1", to select, use \code{dom = "plot1"} to select the plot if
\code{isID = TRUE}. If \code{isID = FALSE}, use \code{dom = "#plot1"}

Other complex selector is supported. First turn \code{isID = FALSE}, then try things
like \code{dom = ".btn i"} selects an icon inside an element
with "btn" class. If more than one element is matched, only the first one will
be screenshoted.}

\item{id}{ID of this button, optional.}

\item{isID}{bool, if the \code{dom} argument is selected by ID or other selector}

\item{class}{string, length 1, other html class add to the button wrapper}

\item{placement}{where should the tiptool place, top, bottom, left, right.}
}
\value{
a button group with several options
}
\description{
A upper level function of \link[drawer:toCanvasBtn]{drawer::toCanvasBtn}. You should only
use it under SPS projects. For you own apps, still use the \link[drawer:toCanvasBtn]{drawer::toCanvasBtn}.
}
\examples{
canvasBtn("#mydiv")
}
