% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dose_response_curve.R
\name{PlotDoseResponseCurve}
\alias{PlotDoseResponseCurve}
\title{Plot Dose Response Curve for Single Drug}
\usage{
PlotDoseResponseCurve(
  data,
  plot_block = 1,
  drug_index = 1,
  adjusted = TRUE,
  Emin = NA,
  Emax = NA,
  grid = TRUE,
  point_color = "#C24B40",
  curve_color = "black",
  text_size_scale = 1,
  plot_title = NULL,
  plot_subtitle = NULL,
  plot_setting = list(cex.lab = 1 * text_size_scale, mgp = c(2, 0.5, 0), font.main = 2,
    font.lab = 1, cex.main = 14/12 * text_size_scale, bty = "l", lwd = 1.5),
  plot_new = TRUE,
  record_plot = TRUE,
  ...
)
}
\arguments{
\item{data}{A list object generated by function \code{\link{ReshapeData}}.}

\item{plot_block}{A character/integer. It indicates the block ID for the
block to visualize.}

\item{drug_index}{A character/integer. It indicates the index of the drug to 
  plot. For example, 1 or "1" indicates to plot "drug1" in the input 
\code{data}.}

\item{adjusted}{A logical value. If it is \code{FALSE}, original response
value will be used to fit the curve. If it is \code{TRUE}, the response
values adjusted by (adding noise and/or imputation) will be plotted.}

\item{Emin}{A numeric or \code{NA}. the minimal effect of the drug used in
the 4-parameter log-logistic function to fit the dose-response curve. If
it is not NA, it is fixed the value assigned by the user. Default setting
is \code{NA}.}

\item{Emax}{A numeric or \code{NA}. the maximal effect of the drug used in
the 4-parameter log-logistic function to fit the dose-response curve. If
it is not NA, it is fixed the value assigned by the user. Default setting
is \code{NA}.}

\item{grid}{A logical value. It indicates whether to show the grids in the
plots. The default value is \code{TRUE}. If \code{grid = NULL} or
\code{grid = FALSE}, there is no grid.}

\item{point_color}{An R color value. It indicates the color for points in
dose response curve plots.}

\item{curve_color}{An R color value. It indicates the color for curves in 
dose response curve plots.}

\item{text_size_scale}{A numeric value. It is used to control the size
of text in the plot. All the text size will multiply by this scale factor.}

\item{plot_title}{A character value or NULL. It specifies the plot title.
If it is \code{NULL}, the function will automatically generate a title.}

\item{plot_subtitle}{A character or NULL. It indicates the subtitle for the
plot. If it is \code{NULL}, the function will automatically generate a 
subtitle.}

\item{plot_setting}{A list of graphical arguments. The arguments are passed 
to \link[graphics]{par} function to modify the appearance of plots.}

\item{plot_new}{A logic value. If it is \code{TRUE}, a new device will be
initiate with \link[graphics]{plot.new}. You might want to set it as
\code{FALSE} while combining with other plots by using
 \link[graphics]{layout} function.}

\item{record_plot}{A logic value. If it is \code{TRUE}, a plot object 
recorded by \link[grDevices]{recordPlot} will be returned. If it is
\code{FALSE}, this function will return \code{NULL}.}

\item{...}{Additional graphical arguments that are inherited from
link[drc]{plot.drc} function. For example, use xlim = c(0.5, 500) or
ylim = (0, 100) to control the ranges of x-axis or y-axis, respectively.}
}
\value{
A plot object recorded by \link[grDevices]{recordPlot} or NULL.
}
\description{
This function will pot the dose response curve fitted by 4 parameters 
log-logistic curve.
}
\examples{
data("mathews_screening_data")
data <- ReshapeData(mathews_screening_data)
p <- PlotDoseResponseCurve(data, plot_block = 1, drug_index = 2, grid = NULL)
replayPlot(p)
}
\author{
\itemize{
  \item Shuyu Zheng \email{shuyu.zheng@helsinki.fi}
  \item Jing Tang \email{jing.tang@helsinki.fi}
}
}
