% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_barometer.R
\name{PlotBarometer}
\alias{PlotBarometer}
\title{Plot Barometer for Responses at One Data Point}
\usage{
PlotBarometer(
  data,
  plot_block = 1,
  plot_concs,
  graduation_color = "#6C6C6C",
  needle_color = "#6C6C6C",
  needle_text_size = 5,
  needle_text_offset = 2,
  graduation_label_size = 4,
  graduation_label_offset = 0.7,
  annotation_label_size = 4,
  annotation_label_offset = 0.6,
  annotation_label_color = "#6C6C6C",
  font_family = "",
  color_bar_color = "#8f1b01",
  color_bar_outer = 9,
  color_bar_inner = 8,
  major_graduation_outer = 7.8,
  minor_graduation_inner = 7.5,
  major_graduation_inner = 7,
  show_concs = TRUE
)
}
\arguments{
\item{data}{A list object generated by function 
\code{\link{CalculateSynergy}}.}

\item{plot_block}{An integer or character. It indicates the block id for the
combination matrix to visualize.}

\item{plot_concs}{A vector of numeric values with the length same as the
number of drugs in selected block. It contains the concentrations  for
"drug1", "drug2", ... The data point selected by these concentrations will
be highlighted in the plot.}

\item{graduation_color}{An R color value. It indicates the color of the
graduation texts and ticks.}

\item{needle_color}{An R color value. It indicates the color of the needle.}

\item{needle_text_size}{A numeric value. It indicates the size of the text
near the center of barometer which showing the response value. The unit is
"mm".}

\item{needle_text_offset}{A numeric value. It is used to set the position of
the response values text. Smaller value means the text is closer to the
center.}

\item{graduation_label_size}{A numeric value. It indicates the size of the
graduation texts. The unit is "mm".}

\item{graduation_label_offset}{A numeric value. It is used to set the
position of graduation texts. Smaller values means the graduation texts is
closer to the ticks. It ranges from 0 to 1.}

\item{annotation_label_size}{A numeric value. It indicates the size of the
labels for the additive effects at the out-most layer. The unit is "mm".}

\item{annotation_label_offset}{A numeric value. It is used to set the
position of additive effect labels. Smaller values means the labels is
closer to the color bar. It ranges from 0 to 1.}

\item{annotation_label_color}{An R color value. It indicates the color of the
additive effects at the out-most layer.}

\item{font_family}{The font family for all the texts in the plot.}

\item{color_bar_color}{An R color value. It indicates the color of the
largest value in the color bar.}

\item{color_bar_outer}{A numerical value. It indicates the proportion of the
radius for the outer side of color bar comparing to the outermost edge for
plotting area. It ranges from 0 to 1.}

\item{color_bar_inner}{A numerical value. It indicates the proportion of the
radius for the inner side of color bar comparing to the outermost edge for
plotting area. It ranges from 0 to 1.}

\item{major_graduation_outer}{A numerical value. It indicates the proportion
of the radius for the outer side of graduation comparing to the outermost
edge for plotting area. It ranges from 0 to 1.}

\item{minor_graduation_inner}{A numerical value. It indicates the proportion
of the radius for the outer side of graduation comparing to the outermost
edge for plotting area. It ranges from 0 to 1.}

\item{major_graduation_inner}{A numerical value. It indicates the proportion
of the radius for the outer side of graduation comparing to the outermost
edge for plotting area. It ranges from 0 to 1.}

\item{show_concs}{A logical value. If it is \code{TRUE}, the concentration of
drugs will be shown on the plot.}
}
\value{
A ggplot object.
}
\description{
This function will plot a barometer. The needle will point at the response
(\% inhibition) at the data point specified by \code{plot_concs}. The
reference additive effects calculated by different models will be marked on
the bar if they are included in input \code{data}.
}
\examples{
data("mathews_screening_data")
data <- ReshapeData(mathews_screening_data)
data <- CalculateSynergy(data, method = c("ZIP", "HSA", "Bliss", "Loewe"))
p <- PlotBarometer(data, plot_block = 1, c(625, 50))
p
}
\references{
Tang J, Wennerberg K and Aittokallio T (2015) 
href{https://www.frontiersin.org/articles/10.3389/fphar.2015.00181/full}{What
 is synergy? The Saariselkä agreement revisited}. Front. Pharmacol. 6:181. 
 doi: 10.3389/fphar.2015.00181
}
\author{
\itemize{
  \item Shuyu Zheng \email{shuyu.zheng@helsinki.fi}
  \item Jing Tang \email{jing.tang@helsinki.fi}
}
}
