% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_multi_drugs.R
\name{GenerateSurface}
\alias{GenerateSurface}
\title{3D Surface Plot for Nulti-drug Combination Dose-Response/Synergy Scores}
\usage{
GenerateSurface(
  dim_reduced_data,
  high_value_color,
  low_value_color,
  show_data_points = TRUE,
  point_color,
  plot_title,
  plot_subtitle,
  legend_title,
  z_axis_title,
  text_size_scale = 1,
  axis_line = FALSE,
  colorbar_tick = FALSE,
  x_range = NULL,
  y_range = NULL,
  z_range = NULL,
  color_range = NULL,
  camera_width = NULL,
  camera_height = NULL,
  camera_scale = 1
)
}
\arguments{
\item{dim_reduced_data}{A list of data frame. It contains the dimension 
  reduced data for all the data points and other information for plotting. It
  is the output of \link{DimensionReduction}
(combination of concentrations). It is}

\item{high_value_color}{An R color value. It indicates the color for the
high values.}

\item{low_value_color}{An R color value. It indicates the color for low
values.}

\item{show_data_points}{A logical value. If it is \code{TRUE}, the raw data
points will be shown on the plot. If it is \code{FALSE}, no points will be
plotted.}

\item{point_color}{An R color value. It indicates the color for data points.}

\item{plot_title}{A character value. It is the title for plot.}

\item{plot_subtitle}{A character value. It is the subtitle for plot.}

\item{legend_title}{A character value. It is the title for legend.}

\item{z_axis_title}{A character value. It is the title for z-axis.}

\item{text_size_scale}{A numeric value. It is used to control the size
of text in the plot. All the text size will multiply by this scale factor.}

\item{axis_line}{A logical value. Whether to show the axis lines and ticks.}

\item{colorbar_tick}{A logical value. Whether to show the ticks on color bar.}

\item{x_range}{A numeric vector with two values or NULL. It is used to set
the range of x axis (coordinate 1). For example, \code{c(-5, 5)} means
coordinate 1 ranges from -5 to 5 in the plot. Default value is \code{NULL}.
The function automatically set the range.}

\item{y_range}{A numeric vector with two values or NULL. It is used to set
the range of y axis (coordinate 2). For example, \code{c(-5, 5)} means
coordinate 2 ranges from -5 to 5 in the plot. Default value is \code{NULL}.
The function automatically set the range.}

\item{z_range}{A vector of two numeric values. They specify the range of
z-axis plotted.Default value is \code{NULL}. The function
automatically set the range.}

\item{color_range}{A vector of two numeric values. They specify the range
of the color bars. The first item (lower bounder) must be less than the
second one (upper bounder). The plotted values larger than defined upper
bounder will be filled in color \code{high_value_color}. The plotted values
less than defined lower bounder will be filled in color
\code{low_value_color}. If the defined range includes 0, value 0 will be
filled in color "white". By default, it is set as \code{NULL} which
means the function will automatically set the color range according to
the plotted values.}

\item{camera_width}{A numeric value or NULL. It indicates the output figure's
width on pixel.}

\item{camera_height}{A numeric value or NULL. It indicates the output
figure's height on pixel.}

\item{camera_scale}{A numeric value. The output plot will multiply 
title/legend/axis/canvas sizes by this factor.}
}
\value{
A ggplot object.
}
\description{
This function will generate a surface plot for multi-drug combinations from
the output of \link{DimensionReduction}. It is an auxiliary function for 
\link{PlotMultiDrugSurface}
}
\author{
\itemize{
  \item Shuyu Zheng \email{shuyu.zheng@helsinki.fi}
  \item Jing Tang \email{jing.tang@helsinki.fi}
}
}
