# Copyright Shuyu Zheng and Jing Tang - All Rights Reserved
# Unauthorized copying of this file, via any medium is strictly prohibited
# Proprietary and confidential
# Written by Shuyu Zheng <shuyu.zheng@helsinki.fi>, March 2021

#' A high-throughput drug combination screening data
#'
#' A recent drug combination screening for the treatment of diffuse large B-cell
#' lymphoma (DLBCL).
#' @format A data frame with the following columns: block_id, drug_row,
#'   drug_col, conc_r, conc_c, response, conc_r_unit, conc_c_unit.
#' @name mathews_screening_data
#' @references Mathews Griner LA, Guha R, Shinn P, Young RM, Keller JM, et al.
#' High-throughput combinatorial screening identifies drugs that cooperate with
#' ibrutinib to kill activated B-cell-like diffuse large B-cell
#' lymphoma cells. Proc Natl Acad Sci USA 2014; 111:2349-54.
NULL
