% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/switchde.R
\name{extract_pars}
\alias{extract_pars}
\title{Extract parameters from fitted model}
\usage{
extract_pars(sde, gene)
}
\arguments{
\item{sde}{The \code{data.frame} returned by \code{switchde}}

\item{gene}{The gene for which to extract parameters}
}
\value{
A vector of length 3 corresonding to the parameters \eqn{\mu_0}, \eqn{k} and \eqn{t_0}
}
\description{
Extract maximum likelihood parameter estimates from a call to \code{switchde}.
}
\examples{
data(synth_gex)
data(ex_pseudotime)
sde <- switchde(synth_gex, ex_pseudotime)
pars <- extract_pars(sde, "Gene1")
}
