% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partial_signature.R
\name{partial_signature}
\alias{partial_signature}
\title{Function to remove the contribution of a SuperSig}
\usage{
partial_signature(data, object)
}
\arguments{
\item{data}{a data frame of mutations containing columns for
\code{sample_id}, \code{age}, \code{IndVar}, and the 96 trinucleotide
mutations (see vignette for details)}

\item{object}{an object of class \code{SuperSig}}
}
\value{
\code{predict_signature} returns the original data frame with 
the contribution of a supervised signature removed
}
\description{
Remove the contribution of a SuperSig from the data and return the data.
}
\examples{

head(example_dt) # use example data from package
input_dt <- make_matrix(example_dt) # convert to correct format
input_dt$IndVar <- c(1, 1, 1, 0, 0) # add IndVar column
supersig <- get_signature(data = input_dt, factor = "Age") # get SuperSig
partial_signature(data = input_dt, object = supersig)

}
