% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forward_selection_by_rank_class.R
\name{fs_line}
\alias{fs_line}
\title{Forward selection line plot}
\usage{
fs_line(...)
}
\arguments{
\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{
fs_line
} object. This object has no \code{output} slots.
See \code{\link[struct]{chart_plot}} in the \code{struct} package to plot this chart object.
}
\description{
A line plot for forward selection. The computed model performance metric is plotted against the number of features included in the model.
}
\section{Inheritance}{

A \code{fs_line} object inherits the following \code{struct} classes: \cr\cr
\verb{[fs_line]} >> \verb{[chart]} >> \verb{[struct_class]}
}

\examples{
M = fs_line()

# some data
D = MTBLS79_DatasetExperiment(filtered=TRUE)

# normalise, impute and scale then remove QCs
P = pqn_norm(qc_label='QC',factor_name='Class') +
    knn_impute(neighbours=5) +
    glog_transform(qc_label='QC',factor_name='Class') +
    filter_smeta(mode='exclude',levels='QC',factor_name='Class')
P = model_apply(P,D)
D = predicted(P)

# forward selection using a PLSDA model
M = forward_selection_by_rank(factor_name='Class',
                             min_no_vars=2,
                             max_no_vars=11,
                             variable_rank=1:2063) *
    (mean_centre() + PLSDA(number_components=1,
                           factor_name='Class'))
M = run(M,D,balanced_accuracy())

# chart
C = fs_line()
chart_plot(C,M)

}
