% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_by_name_class.R
\name{filter_by_name}
\alias{filter_by_name}
\title{Filter by name}
\usage{
filter_by_name(mode = "exclude", dimension = "sample", names, ...)
}
\arguments{
\item{mode}{(character) The filtering mode controls whether samples/features are mode="included" or mode="excluded" based on their name. The default is \code{"exclude"}.}

\item{dimension}{(character) The filtering dimensions controls whether dimension="sample" or dimension="variable" are filtered based on their name. The default is \code{"sample"}.}

\item{names}{(character, numeric, logical) The name of features/samples to be filtered. Must be an exact match. Can also provide indexes (numeric) or logical.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{filter_by_name} object with the following \code{output} slots:
\tabular{ll}{
\code{filtered} \tab          (DatasetExperiment)  \cr
}
}
\description{
Filter samples/variables by row/column name, index or logicals.
}
\section{Inheritance}{

A \code{filter_by_name} object inherits the following \code{struct} classes: \cr\cr
\verb{[filter_by_name]} >> \verb{[model]} >> \verb{[struct_class]}
}

\examples{
M = filter_by_name(
      mode = "exclude",
      dimension = "sample",
      names = character(0))

D = MTBLS79_DatasetExperiment()
M = filter_by_name(mode='exclude',dimension='variable',names=c(1,2,3))
M = model_apply(M,D)
}
