% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova_class.R
\name{ANOVA}
\alias{ANOVA}
\title{Analysis of Variance}
\usage{
ANOVA(alpha = 0.05, mtc = "fdr", formula, ss_type = "III", ...)
}
\arguments{
\item{alpha}{(numeric) The p-value cutoff for determining significance. The default is \code{0.05}.\cr}

\item{mtc}{(character) Multiple test correction method. Allowed values are limited to the following: \itemize{ \item{\code{"bonferroni"}: Bonferroni correction in which the p-values are multiplied by the number of comparisons.}\item{\code{"fdr"}: Benjamini and Hochberg False Discovery Rate correction.}\item{\code{"none"}: No correction.}} The default is \code{"fdr"}.}

\item{formula}{(formula) A symbolic description of the model to be fitted.}

\item{ss_type}{(character) ANOVA sum of squares. Allowed values are limited to the following: \itemize{ \item{\code{"I"}: Type I sum of squares.}\item{\code{"II"}: Type II sum of squares.}\item{\code{"III"}: Type III sum of squares.}} The default is \code{"III"}.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{ANOVA} object with the following \code{output} slots:
\tabular{ll}{
\code{f_statistic} \tab          (data.frame) The value of the calculated statistic. \cr
\code{p_value} \tab          (data.frame) The probability of observing the calculated statistic if the null hypothesis is true. \cr
\code{significant} \tab          (data.frame) True/False indicating whether the p-value computed for each variable is less than the threshold. \cr
}
}
\description{
Analysis of Variance (ANOVA) is a univariate method used to analyse the difference among group means. Multiple test corrected p-values are computed to indicate significance for each feature.
}
\details{
This object makes use of functionality from the following packages:\itemize{  \item{\code{car}}}
}
\section{Inheritance}{

A \code{ANOVA} object inherits the following \code{struct} classes: \cr\cr
\verb{[ANOVA]} >> \verb{[model]} >> \verb{[struct_class]}
}

\examples{
M = ANOVA(
      alpha = 0.05,
      mtc = "fdr",
      formula = y ~ x,
      ss_type = "III")

D = iris_DatasetExperiment()
M = ANOVA(formula=y~Species)
M = model_apply(M,D)
}
\references{
Fox J, Weisberg S (2019). \emph{An R Companion to Applied Regression}, Third
edition. Sage, Thousand Oaks CA.
\url{https://socialsciences.mcmaster.ca/jfox/Books/Companion/}.
}
