% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGeneQCs.R
\name{plotGeneQC}
\alias{plotGeneQC}
\title{Plot gene-wise QC plot}
\usage{
plotGeneQC(
  spe,
  top_n = 9,
  ordannots = c(),
  point_size = 1,
  line_type = "dashed",
  line_col = "darkred",
  line_cex = 1,
  hist_col = "black",
  hist_fill = "skyblue",
  bin_num = 30,
  text_size = 13,
  layout_ncol = 1,
  layout_nrow = 2,
  layout_height = c(1, 1),
  ...
)
}
\arguments{
\item{spe}{A SpatialExperiment object.}

\item{top_n}{Integer. Indicating the top n genes will be plotted. Default is 9.}

\item{ordannots}{variables or computations to sort samples by (tidy style).}

\item{point_size}{Numeric. Point size.}

\item{line_type}{Character. Line types for ggplot.}

\item{line_col}{Color for line.}

\item{line_cex}{Cex for line.}

\item{hist_col}{Color for histogram.}

\item{hist_fill}{Fill for histogram.}

\item{bin_num}{Bin numbers for histogram.}

\item{text_size}{Text size.}

\item{layout_ncol}{Integer. Column number for layout. Default is 1.}

\item{layout_nrow}{Integer. Row number for layout. Default is 2.}

\item{layout_height}{Vector of numerics with length of 2. Default is c(1, .4).}

\item{...}{aesthetic mappings to pass to \code{ggplot2::aes()} of the dot plots.}
}
\value{
A ggplot object
}
\description{
Plot gene-wise QC plot
}
\examples{
data("dkd_spe_subset")
spe <- addPerROIQC(dkd_spe_subset)
plotGeneQC(spe)
}
