% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Run_Visualization.R
\name{Run_Visualization}
\alias{Run_Visualization}
\title{Visualize pre-processed sST data}
\usage{
Run_Visualization(
  matched.data = NULL,
  config,
  Vis.spatial = TRUE,
  Vis.read = TRUE,
  show.config = TRUE
)
}
\arguments{
\item{matched.data}{A data frame containing spatial transcriptomics data, including UMI counts and spatial coordinates. This is usually obtained from 'Run_loc_match' function.}

\item{config}{Path to the YAML configuration file.}

\item{Vis.spatial}{Logical value indicating whether to visualize spatial data. Defaults to TRUE.}

\item{Vis.read}{Logical value indicating whether to visualize read-level data. Defaults to TRUE.}

\item{show.config}{Logical value indicating whether to print the configuration. Defaults to TRUE.}
}
\value{
A list contains spatial and read level visualization results.
}
\description{
This function visualizes both spatial-level and read-level information either before or after the 'Run_QC' step. It outputs raw and log-transformed UMI count plots for spatial flag, and demultiplexing and mapping statistics for read flag.
}
\examples{
temp_config <- tempfile(fileext = ".yml")
writeLines("technology_version: 'Visium 1.0'\noutput_directory: '.'", temp_config)
matched.data <- data.frame(
X_coordinate = runif(10, 0, 100),
Y_coordinate = runif(10, 0, 100),
UMI_count = sample(seq_len(100), 10),
spatial_name = paste0("Spot", seq_len(10)),
stringsAsFactors = FALSE
)
vis_results <- Run_Visualization(
  matched.data = matched.data, 
  config = temp_config, 
  Vis.spatial = TRUE, 
  Vis.read = FALSE, 
  show.config = FALSE
)
}
