% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Run_Interactive.R
\name{Run_Interactive}
\alias{Run_Interactive}
\title{Interactive Visualization for Spatial Transcriptomics Data and spot plot with save functionality}
\usage{
Run_Interactive(
  matched_data,
  clustering_result,
  background_img = NULL,
  reduction_method = "tsne",
  point_size = 1
)
}
\arguments{
\item{matched_data}{A data frame containing matched spatial coordinates with raw UMI counts.}

\item{clustering_result}{A data frame containing matched spatial coordinates with raw UMI counts.}

\item{background_img}{Optional background H&E image.}

\item{reduction_method}{T-SNE ("tsne") or UMAP ("umap") result data frame obtained from 'Run_Clustering' function. Default set as "tsne".}

\item{point_size}{Size of point shown in the spatial heatmap. Default set as 1.}
}
\value{
R-shiny interactive webpage.
}
\description{
Interactive Visualization for Spatial Transcriptomics Data and spot plot with save functionality
}
\details{
This function generates interactive plots to visualize spatial transcriptomics data. It takes matched spatial coordinates and raw UMI counts to produce customized t-SNE or UMAP plots overlayed on a optional background H&E image.
}
\examples{
matched_data <- data.frame(
X_coordinate = runif(10, 0, 100),
Y_coordinate = runif(10, 0, 100),
UMI_count = sample(seq_len(100), 10),
spatial_name = paste0("Spot", seq_len(10)),
stringsAsFactors = FALSE
)
clustering_result <- data.frame(
TSNE1 = runif(10, -50, 50),
TSNE2 = runif(10, -50, 50),
spot = paste0("Spot", seq_len(10)),
cluster = sample(seq_len(3), 10, replace = TRUE),
stringsAsFactors = FALSE
)
if (interactive()) {
Run_Interactive(
  matched_data = matched_data, 
  clustering_result = clustering_result, 
  background_img = NULL, 
  reduction_method = "tsne", 
  point_size = 1)
                               }
}
