% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataPrep.R
\name{dataPrepFromSeurat}
\alias{dataPrepFromSeurat}
\title{Data Preparation from Seurat Object}
\usage{
dataPrepFromSeurat(SeuratObj, label)
}
\arguments{
\item{SeuratObj}{input Seurat object that contains labels for each barcode}

\item{label}{the column name of the label information in "meta.data"}
}
\value{
A data.frame contains the pixel information and cluster labels for each barcode the sample.
The index contains barcodes, and at least three other columns that have these information are required and the column names should be the same as following:
"imagerow": The row pixel coordinate of the center of the spot
"imagecol": The column pixel coordinate of the center of the spot
"Cluster": The label that corresponding to this barcode
}
\description{
This data preparation function creates a data.frame from a Seurat Object.
It extracts the pixel information and cluster labels of each barcode from user's input Seurat Object
and generate a data.frame with a certain format which is required for the algorithm.
If the user has customized labels, this function will change the column name to "Cluster" when generating
the data.frame to make it consistent to the required format.
}
\examples{
fpath <- system.file("extdata", "SeuratBC.rda", package="stJoincount")
load(fpath)
df <- dataPrepFromSeurat(seuratBC, "Cluster")
}
