#' Gene Expression Values for PDAC Cancer Cell Lines exposed to Hypoxia
#'
#' @docType data
#' @usage data(tcga_expr_df)
#'
#' @source This data is generated by the TCGA Research Network:
#' https://www.cancer.gov/tcga and downloaded from the NCI Genomic Data Commons.
#' @description  A data frame with columns:
#' \describe{
#'  \item{tcga_id}{String. TCGA aliquot barcode}
#'  \item{study}{String. TCGA study abbreviation}
#'  \item{is_normal}{Boolean. TRUE if sample is adjacent normal,
#'  FALSE if tumor.}
#'  \item{libsize_75percent}{Float. Library size as estimated by the 75th
#'  quartile.}
#'  \item{ENSG00000070831}{String. Library size normalized gene expression value for
#'  this gene.}
#' }
#' @examples
#' \dontrun{
#'  tcga_expr_df
#' }
"tcga_expr_df"
