% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zinb-estimate.R
\name{zinbEstimate}
\alias{zinbEstimate}
\alias{zinbEstimate.SingleCellExperiment}
\alias{zinbEstimate.matrix}
\title{Estimate ZINB-WaVE simulation parameters}
\usage{
zinbEstimate(
  counts,
  design.samples = NULL,
  design.genes = NULL,
  common.disp = TRUE,
  iter.init = 2,
  iter.opt = 25,
  stop.opt = 1e-04,
  params = newZINBParams(),
  verbose = TRUE,
  BPPARAM = SerialParam(),
  ...
)

\method{zinbEstimate}{SingleCellExperiment}(
  counts,
  design.samples = NULL,
  design.genes = NULL,
  common.disp = TRUE,
  iter.init = 2,
  iter.opt = 25,
  stop.opt = 1e-04,
  params = newZINBParams(),
  verbose = TRUE,
  BPPARAM = SerialParam(),
  ...
)

\method{zinbEstimate}{matrix}(
  counts,
  design.samples = NULL,
  design.genes = NULL,
  common.disp = TRUE,
  iter.init = 2,
  iter.opt = 25,
  stop.opt = 1e-04,
  params = newZINBParams(),
  verbose = TRUE,
  BPPARAM = SerialParam(),
  ...
)
}
\arguments{
\item{counts}{either a counts matrix or a SingleCellExperiment object
containing count data to estimate parameters from.}

\item{design.samples}{design matrix of sample-level covariates.}

\item{design.genes}{design matrix of gene-level covariates.}

\item{common.disp}{logical. Whether or not a single dispersion for all
features is estimated.}

\item{iter.init}{number of iterations to use for initialization.}

\item{iter.opt}{number of iterations to use for optimization.}

\item{stop.opt}{stopping criterion for optimization.}

\item{params}{ZINBParams object to store estimated values in.}

\item{verbose}{logical. Whether to print progress messages.}

\item{BPPARAM}{A \code{\link[BiocParallel]{BiocParallelParam}} instance
giving the parallel back-end to be used. Default is
\code{\link[BiocParallel]{SerialParam}} which uses a single core.}

\item{...}{additional arguments passes to \code{\link[zinbwave]{zinbFit}}.}
}
\value{
ZINBParams object containing the estimated parameters.
}
\description{
Estimate simulation parameters for the ZINB-WaVE simulation from a real
dataset.
}
\details{
The function is a wrapper around \code{\link[zinbwave]{zinbFit}} that takes
the fitted model and inserts it into a \code{\link{ZINBParams}} object. See
\code{\link{ZINBParams}} for more details on the parameters and
\code{\link[zinbwave]{zinbFit}} for details of the estimation procedure.
}
\examples{
if (requireNamespace("zinbwave", quietly = TRUE)) {
    library(scuttle)
    set.seed(1)
    sce <- mockSCE(ncells = 20, ngenes = 100)

    params <- zinbEstimate(sce)
    params
}

}
