% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCE-functions.R
\name{minimiseSCE}
\alias{minimiseSCE}
\title{Minimise SCE}
\usage{
minimiseSCE(
  sce,
  rowData.keep = FALSE,
  colData.keep = FALSE,
  metadata.keep = FALSE,
  assays.keep = "counts",
  sparsify = c("auto", "all", "none"),
  verbose = TRUE
)
}
\arguments{
\item{sce}{SingleCellExperiment object}

\item{rowData.keep}{Either TRUE (keep all rowData columns), FALSE (remove all
rowData columns) or a character vector with the names of the rowData columns
to keep}

\item{colData.keep}{Either TRUE (keep all colData columns), FALSE (remove all
colData columns) or a character vector with the names of the colData columns
to keep}

\item{metadata.keep}{Either TRUE (keep all metadata), FALSE (remove all
metadata) or a character vector with the names of the metadata items to keep}

\item{assays.keep}{Either TRUE (keep all assays), FALSE (remove all
assays) or a character vector with the names of the assays to keep}

\item{sparsify}{Whether to convert assay matrices to sparse format. Either
"all", "none" or "auto" (default) to only convert those matrices that will
result in a size reduction}

\item{verbose}{Whether to print status messages}
}
\value{
SingleCellExperiment object
}
\description{
Reduce the size of a SingleCellExperiment object by unneeded information.
}
\examples{

sce <- splatSimulate(verbose = FALSE)
sce.min <- minimiseSCE(sce, verbose = FALSE)
object.size(sce)
object.size(sce.min)

}
