% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCellTypeProps.R
\name{plotCellTypeProps}
\alias{plotCellTypeProps}
\title{Plot cell type proportions for each sample}
\usage{
plotCellTypeProps(x = NULL, clusters = NULL, sample = NULL)
}
\arguments{
\item{x}{object of class \code{SingleCellExperiment} or \code{Seurat}}

\item{clusters}{a factor specifying the cluster or cell type for every cell.
For \code{SingleCellExperiment} objects this should correspond to a column
called \code{clusters} in the \code{colData} assay. For \code{Seurat}
objects this will be extracted by a call to \code{Idents(x)}.}

\item{sample}{a factor specifying the biological replicate for each cell.
For \code{SingleCellExperiment} objects this should correspond to a column
called \code{sample} in the \code{colData} assay and for \code{Seurat}
objects this should correspond to \code{x$sample}.}
}
\value{
a ggplot2 object
}
\description{
This is a plotting function that shows the cell type composition for each
sample as a stacked barplot. The \code{plotCellTypeProps} returns a
\code{ggplot2} object enabling the user to make style changes as required.
}
\examples{

library(speckle)
library(ggplot2)
library(limma)

# Generate some fake data from a multinomial distribution
# Group A, 4 samples, 1000 cells in each sample
countsA <- rmultinom(4, size=1000, prob=c(0.1,0.3,0.6))
colnames(countsA) <- paste("s",1:4,sep="")

# Group B, 3 samples, 800 cells in each sample

countsB <- rmultinom(3, size=800, prob=c(0.2,0.05,0.75))
colnames(countsB) <- paste("s",5:7,sep="")
rownames(countsA) <- rownames(countsB) <- paste("c",0:2,sep="")

allcounts <- cbind(countsA, countsB)
sample <- c(rep(colnames(allcounts),allcounts[1,]),
          rep(colnames(allcounts),allcounts[2,]),
          rep(colnames(allcounts),allcounts[3,]))
clust <- rep(rownames(allcounts),rowSums(allcounts))

plotCellTypeProps(clusters=clust, sample=sample)

}
\author{
Belinda Phipson
}
