% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplotColors.R
\name{ggplotColors}
\alias{ggplotColors}
\title{Output a vector of colours based on the ggplot colour scheme}
\usage{
ggplotColors(g)
}
\arguments{
\item{g}{the number of colours to be generated.}
}
\value{
a vector with the names of the colours.
}
\description{
This function takes as input the number of colours the user would like, and
outputs a vector of colours in the ggplot colour scheme.
}
\examples{
# Generate a palette of 6 colours
cols <- ggplotColors(6)
cols

# Generate some count data
y <- matrix(rnbinom(600, mu=100, size=1), ncol=6)

par(mfrow=c(1,1))
boxplot(y, col=cols)

}
\author{
Belinda Phipson
}
