% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dim.R
\name{plot_dim}
\alias{plot_dim}
\title{Embedding plots of single cells/bulk tissues after co-clustering}
\usage{
plot_dim(
  sce,
  dim = NULL,
  color.by,
  group.sel = NULL,
  row.sel = NULL,
  cocluster.only = TRUE,
  x.break = NULL,
  y.break = NULL,
  panel.grid = FALSE,
  lgd.title.size = 13,
  lgd.key.size = 0.03,
  lgd.text.size = 12,
  point.size = 3,
  bulk.size = 5,
  alpha = 0.7,
  stroke = 0.2,
  bulk.stroke = 1,
  axis.text.size = 10,
  axis.title.size = 11,
  lgd.pos = "right",
  lgd.ncol = 1,
  lgd.l = 0,
  lgd.r = 0.01
)
}
\arguments{
\item{sce}{A \code{SingleCellExperiment} object with reduced dimensions seen by \code{reducedDimNames(sce)}.}

\item{dim}{One of \code{PCA}, \code{UMAP}, \code{TSNE}, the method for reducing dimensionality.}

\item{color.by}{One of the column names in the \code{colData} slot of \code{sce}.}

\item{group.sel}{An entry in the \code{color.by} column. All cells under this entry are selected as a group to show.}

\item{row.sel}{A numeric vector of row numbers in the \code{colData} slot of \code{sce}. The cells corresponding to these rows are highlighted and plotted on top of other cells.}

\item{cocluster.only}{Logical, only applicable when \code{color.by='cluster'}. If \code{TRUE} (default), only coclusters (including bulk and cells) are colored and the rest are in gray.}

\item{x.break, y.break}{Two numeric vectors for x, y axis breaks respectively. E.g. \code{seq(-10, 10, 2)}. The default is \code{NULL}.}

\item{panel.grid}{Logical. If \code{TRUE}, the panel grid will be shown.}

\item{lgd.title.size, lgd.key.size, lgd.text.size}{The size of legend plot title, legend key, legend text respectively.}

\item{point.size, bulk.size}{The size of cells and bulk tissues respectively.}

\item{alpha}{The transparency of cells and bulk tissues. The default is 0.6.}

\item{stroke, bulk.stroke}{The line width of cells and bulk tissues respectively.}

\item{axis.text.size, axis.title.size}{The size of axis text and title respectively.}

\item{lgd.pos}{The legend position, one of \code{top}, \code{right}, \code{bottom}, \code{left}.}

\item{lgd.ncol}{The number of legend columns.}

\item{lgd.l, lgd.r}{The left and right margins of legends.}
}
\value{
An object of ggplot.
}
\description{
Embedding plots of single cells/bulk tissues after co-clustering
}
\examples{
library(scran); library(scuttle) 
sce <- mockSCE(); sce <- logNormCounts(sce) 
# Modelling the variance.
var.stats <- modelGeneVar(sce) 
sce <- denoisePCA(sce, technical=var.stats, subset.row=rownames(var.stats)) 
plot_dim(sce, dim='PCA', color.by='Cell_Cycle')
# See function "coclus_meta" by running "?coclus_meta".
}
\references{
Amezquita R, Lun A, Becht E, Carey V, Carpp L, Geistlinger L, Marini F, Rue-Albrecht K, Risso D, Soneson C, Waldron L, Pages H, Smith M, Huber W, Morgan M, Gottardo R, Hicks S (2020). “Orchestrating single-cell analysis with Bioconductor.” Nature Methods, 17, 137–145. https://www.nature.com/articles/s41592-019-0654-x
H. Wickham. ggplot2: Elegant Graphics for Data Analysis. Springer-Verlag New York, 2016.
Morgan M, Obenchain V, Hester J, Pagès H (2021). SummarizedExperiment: SummarizedExperiment container. R package version 1.24.0, https://bioconductor.org/packages/SummarizedExperiment.
Lun ATL, McCarthy DJ, Marioni JC (2016). “A step-by-step workflow for low-level analysis of single-cell RNA-seq data with Bioconductor.” F1000Res., 5, 2122. doi: 10.12688/f1000research.9501.2.
McCarthy DJ, Campbell KR, Lun ATL, Willis QF (2017). “Scater: pre-processing, quality control, normalisation and visualisation of single-cell RNA-seq data in R.” Bioinformatics, 33, 1179-1186. doi: 10.1093/bioinformatics/btw777.
}
\author{
Jianhai Zhang \email{jzhan067@ucr.edu} \cr Dr. Thomas Girke \email{thomas.girke@ucr.edu}
}
